<?php
// Include config file
require_once 'config.php';
 
// Define variables and initialize with empty values
$username = $password = "";
$username_err = $password_err = "";
 
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Check if username is empty
    if(empty(trim($_POST["username"]))){
        $username_err = 'Please enter username.';
    } else{
        $username = trim($_POST["username"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST['password']))){
        $password_err = 'Please enter your password.';
    } else{
        $password = trim($_POST['password']);
    }
    
    // Validate credentials
    if(empty($username_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT username, password, id, user_type, created_at, creator_ip, profile_pic, full_name, email, phone_no  FROM adm_user WHERE username = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_username);
            
            // Set parameters
            $param_username = $username;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if username exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $username, $hashed_password, $id, $user_type, $created_at, $creator_ip, $profile_pic, $full_name, $email, $phone_no);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            /* Password is correct, so start a new session and
                            save the username to the session */
                            session_start();
                            $_SESSION['username'] = $username; 
							
							$_SESSION['password']=$password;
							$_SESSION['id']=$id;
							$_SESSION['user_type']=$user_type;
							$_SESSION['created_at']=$created_at;
							$_SESSION['creator_ip']=$creator_ip;
							$_SESSION['profile_pic']=$profile_pic;
							$_SESSION['full_name']=$full_name;
							$_SESSION['email']=$email;
							$_SESSION['phone_no']=$phone_no;
                            header("location: dashboard.php");
                        } else{
                            // Display an error message if password is not valid
                            $password_err = 'The password you entered was not valid.';
                        }
                    }
                } else{
                    // Display an error message if username doesn't exist
                    $username_err = 'No account found with that username.';
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>
 
<!DOCTYPE html>
<html lang="en">
<head>
  <title>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</title>
<link href='https://fonts.googleapis.com/css?family=Ubuntu:500' rel='stylesheet' type='text/css'>
<style>
body {
  
  margin:0px;
  font-family: 'Ubuntu', sans-serif;
	background-size: 100% 110%;
}
h1, h2, h3, h4, h5, h6, a {
  margin:0; padding:0;
}
.login {
  border-radius:5px;
  background-color:#e09018;
  margin:0 auto;
  max-width:500px;
 
}
.login-header {
  color:#fff;
  text-align:center;
  font-size:100%;
}
/* .login-header h1 {
   text-shadow: 0px 5px 15px #000; */
}
.login-form {
  border:.5px solid #fff;
  background:#4facff;
  border-radius:10px;
  box-shadow:0px 0px 10px #000;
}
.login-form h3 {
  text-align:left;
  margin-left:40px;
  color:#fff;
}
.login-form {
  box-sizing:border-box;
  padding-top:15px;
	padding-bottom:10%;
  margin:5% auto;
  text-align:center;
}
.login input[type="text"],
.login input[type="password"] {
  max-width:400px;
	width: 80%;
  line-height:3em;
  font-family: 'Ubuntu', sans-serif;
  margin:1em 2em;
  border-radius:5px;
  border:2px solid #f2f2f2;
  outline:none;
  padding-left:10px;
}
.login-form input[type="button"] {
  height:30px;
  width:100px;
  background:#fff;
  border:1px solid #f2f2f2;
  border-radius:20px;
  color: slategrey;
  text-transform:uppercase;
  font-family: 'Ubuntu', sans-serif;
  cursor:pointer;
}
.sign-up{
  color:#f2f2f2;
  margin-left:-70%;
  cursor:pointer;
  text-decoration:underline;
}
.no-access {
  color:black;
  margin:20px 0px 20px -57%;
  text-decoration:underline;
  cursor:pointer;
}
  
.try-again {
  color:#f2f2f2;
  text-decoration:underline;
  cursor:pointer;
}

/*Media Querie*/
@media only screen and (min-width : 150px) and (max-width : 530px){
  .login-form h3 {
    text-align:center;
    margin:0;
  }
  .sign-up, .no-access {
    margin:10px 0;
  }
  .login-button {
    margin-bottom:10px;
  }
}
</style>
<meta name="description" content="toyam securities management pvt ltd Ranchi." />
<meta name="keywords" />
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="bootstrap.min.css">
  <script src="jquery.min.js"></script>
  <script src="bootstrap.min.js"></script>

  <link rel="stylesheet" href="style_index.css">
   

<link rel="shortcut icon" href="toyam.png" />
<link rel="apple-touch-icon" sizes="152x152" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="120x120" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="76x76" href="toyam.png"/>
<link rel="apple-touch-icon" sizes="60x60" href="toyam.png"/>
</head>
<body>

<nav class="navbar navbar-inverse">
  <div class="container-fluid">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>                        
      </button>
    </div>
    <div class="collapse navbar-collapse" id="myNavbar">
      <ul class="nav navbar-nav">
        <li class="active"><a href="index.php">Home</a></li>
        <li><a href="http://www.toyamservices.com" id="myBtn">Website</a></li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li><a href="#"><i class="fa fa-info-circle" style="font-size:36px"></i> FAQs</a></li>
      </ul>
    </div>
  </div>
</nav>






<div class="jumbotron" style="padding:0;">
<!===============================================================!>
<div class="container-fluid bg-3 text-center" style="background-color: #dbd895;//DAA520">    
  <div class="row">

<br>
<div class="col-sm-2">
  <div class="container text-center">
    <img id="home" src="toyam.png">
  </div>
</div>
<div class="col-sm-8">
  <div class="container text-center">
	
    <p><font size="6" color="black" face="Orator Std"><strong>TOYAM SECURITY AND FACILITY MANAGEMENT PVT. LTD.</strong></font></p>
    
	
  </div>
</div>
<div class="col-sm-2">
  <div class="container text-center">
  
    <font size="2" color="white" face="Goudy Old Style">Toyam Securities and Facility Management Pvt. Ltd.</font>
                 <BR>
	<font size="2" color="white" face="Goudy Old Style">C/O- Executive Internet Cafe</font>
	<font size="2" color="white" face="Goudy Old Style">Ratu Chatti, P.O_+P.S- Ratu</font>
        <font size="2" color="white" face="Goudy Old Style">Pin-835222</font>
        <font size="2" color="white" face="Goudy Old Style">Dist.- Ranchi (JHARKHAND)</font>
  </div>
</div>

    </div>
  </div>

</div>









  
<div class="margin">


<div class="login">
  <div class="login-header">
  
  
  <br>
    <h2>ADMINISTRATOR LOGIN</h2>
  </div>

<div class="login-form">
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            
                <label>Username:</label>
                <input type="text" name="username"class="form-control" value="<?php echo $username; ?>">
                <span class="help-block"><?php echo $username_err; ?></span>
              
            
                <label>Password:</label>
                <input type="password" name="password" class="form-control">
                <span class="help-block"><?php echo $password_err; ?></span>
          
            
                <input type="submit" class="login-button" value="Submit">
           
         </form>

</div>

</div>


</div>	


<footer class="container-fluid text-center">
<font color="white">
  <h5>
  Powered by&nbsp;
  <b></i><a href="http://www.vbpwebsoft.com"><font color="white">VBP Websoft</font></a></i></b>
  </h5>

<h6>Copyright &nbsp;&copy;TOYAM SECURITY & FACILITY MANAGEMENT PVT. LTD.
&nbsp; All Rights Reserved.
</h6></font></footer>
</body>
<script>
$('.error-page').hide(0);

$('.login-button , .no-access').click(function(){
  $('.login').slideUp(500);
  $('.error-page').slideDown(1000);
});

$('.try-again').click(function(){
  $('.error-page').hide(0);
  $('.login').slideDown(1000);
});
</script>
</html>